define(function () {

  var component = {
    data() {
      return {};
    }
  };

  component.originalTemplate = "default";
  component.template = `
<wizdomWebpart data-v-890ebe2e v-if="employees" :environmentInfo="environmentInfo" :chromeProperties="webpartProperties.chromeProperties" 
:title="'New Employees' | translate" @titleChanged="webpartProperties.title = $event" :dynamicData="employees.length" class="newEmployees">
 <div data-v-890ebe2e class="container">
    <div data-v-890ebe2e class="wizdom-employees" v-if="employees && employees.length > 0">
        <div data-v-890ebe2e class="wizdom-employees-row" :key="employee.accountName" v-for="employee in employees">
            <div data-v-890ebe2e class="wizdom-employees-imgColumn">
                <presencePicture data-v-890ebe2e size="AVATAR" :accountname="employee.accountName" :siteurl="siteUrl" />
            </div>

            <div data-v-890ebe2e class="wizdom-employees-textColumn">
                <h4 data-v-890ebe2e class="name"><a data-v-890ebe2e :href="employee.publicUrl">{{employee.name}}</a></h4>
                <section data-v-890ebe2e>
                    <div data-v-890ebe2e class="department" v-show="employee.department.length"><b data-v-890ebe2e>{{'Department' | translate}}:</b> {{employee.department}}</div>
					          <div data-v-890ebe2e class="workedsince" v-show="employee.date.length"><b data-v-890ebe2e>{{webpartProperties.dateText}}:</b> {{employee.date | moment("M/D/YYYY")}}</div>
                </section>
            </div>
        </div>
    </div>  
 <div data-v-890ebe2e v-else>
    {{"No employees found." | translate}}
 </div>
 </div>
 </wizdomWebpart>
`;
  component.styles = `
.container[data-v-890ebe2e] {
  color: "[theme:neutralPrimary, default: #333333]";
  margin: 20px 0;
}
.container a[data-v-890ebe2e] {
    color: "[theme:neutralPrimary, default: #333333]";
    text-decoration: none;
}
.container .wizdom-employees[data-v-890ebe2e] {
    text-align: left;
}
.container .wizdom-employees .wizdom-employees-row[data-v-890ebe2e] {
      display: flex;
      align-items: center;
      width: 100%;
      padding: 10px 0;
}
.container .wizdom-employees .wizdom-employees-row[data-v-890ebe2e]:first-child {
        padding: 0;
}
.container .wizdom-employees .wizdom-employees-row .wizdom-employees-imgColumn[data-v-890ebe2e] {
        width: 48px;
}
.container .wizdom-employees .wizdom-employees-row .wizdom-employees-textColumn[data-v-890ebe2e] {
        display: table-cell;
        -ms-word-wrap: break-word;
        word-wrap: break-word;
        padding-left: 12px;
        vertical-align: middle;
}
.container .wizdom-employees .wizdom-employees-row .wizdom-employees-textColumn h4[data-v-890ebe2e] {
          margin: 0;
          font-weight: 500;
}
.container .name[data-v-890ebe2e] {
    font-size: 16px;
    line-height: 20px;
}
.container b[data-v-890ebe2e] {
    font-weight: bold;
}


`;

  return component;

});
